package demo2018.C_my_demo;

import java.io.IOException;

import com.yworks.yfiles.algorithms.Cycles;
import com.yworks.yfiles.algorithms.EdgeList;
import com.yworks.yfiles.algorithms.Graph;
import com.yworks.yfiles.algorithms.IEdgeCursor;
import com.yworks.yfiles.geometry.RectD;
import com.yworks.yfiles.graph.IEdge;
import com.yworks.yfiles.graph.IGraph;
import com.yworks.yfiles.graph.styles.PolylineEdgeStyle;
import com.yworks.yfiles.layout.YGraphAdapter;
import com.yworks.yfiles.view.GraphComponent;
import com.yworks.yfiles.view.Pen;

public class VisualDemo 
{
	
	public static void main(String[] args)
	{
		GraphComponent graphComponent = new GraphComponent();
		//import graph
		try 
		{
			graphComponent.importFromGraphML("src/main/java/demo2018/C_my_demo/graph2.graphml");
		} 
		catch (IOException e) 
		{
			e.printStackTrace();
		}
		
		IGraph iGraph = graphComponent.getGraph();
	    YGraphAdapter adapter = new YGraphAdapter(iGraph);
	    Graph graph = adapter.getYGraph();
	    
	    EdgeList edges = Cycles.findAllCycleEdges(graph, false);
	    
	    for(IEdgeCursor ec = edges.edges(); ec.ok(); ec.next())
	    {
	    	//each edge which belongs to a cycle change its color to red
	    	System.out.println(ec.edge());
	    	IEdge iE = adapter.getOriginalEdge(ec.edge());
	    	PolylineEdgeStyle s=(PolylineEdgeStyle) iE.getStyle().clone();
	    	Pen p=Pen.getRed();
	    	s.setPen(p);
	    	iGraph.setStyle(iE, s);
	    }
	    //export graph
		try 
		{
			graphComponent.exportToGraphML("src/main/java/demo2018/C_my_demo/graph3.graphml");
		} 
		catch (IOException e) 
		{
			e.printStackTrace();
		}
	}

}
