package demo2018.C_my_demo;

import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;

import com.yworks.yfiles.geometry.PointD;
import com.yworks.yfiles.geometry.RectD;
import com.yworks.yfiles.graph.IBend;
import com.yworks.yfiles.graph.IEdge;
import com.yworks.yfiles.graph.IGraph;
import com.yworks.yfiles.graph.ILabel;
import com.yworks.yfiles.graph.INode;
import com.yworks.yfiles.graph.IPort;
import com.yworks.yfiles.graph.portlocationmodels.FreeNodePortLocationModel;
import com.yworks.yfiles.view.GraphComponent;
import com.yworks.yfiles.view.input.GraphEditorInputMode;

public class SimpleFrame 
{

	public SimpleFrame() 
	{
		// create a component for displaying and editing a graph.
		GraphComponent graphComponent = new GraphComponent();
		
		IGraph graph = graphComponent.getGraph();

		INode node1 = graph.createNode(new RectD(0, 0, 30, 30));
		INode node2 = graph.createNode(new RectD(100, 0, 30, 30));
		INode node3 = graph.createNode(new RectD(300, 300, 60, 30));

		IEdge edge1 = graph.createEdge(node1, node2);
		IEdge edge2 = graph.createEdge(node2, node3);

		IBend bend1 = graph.addBend(edge2, new PointD(330, 15));

		IPort portAtNode1 = graph.addPort(node1);
		IPort portAtNode3 = graph.addPort(node3, FreeNodePortLocationModel.NODE_LEFT_ANCHORED);
		IEdge edgeAtPorts = graph.createEdge(portAtNode1, portAtNode3);

		ILabel ln1 = graph.addLabel(node1, "n1");
		ILabel ln2 = graph.addLabel(node2, "n2");
		ILabel ln3 = graph.addLabel(node3, "n3");
		ILabel le3 = graph.addLabel(edgeAtPorts, "Edge at Ports");

		// create a top-level window and add the graph component.
		JFrame frame = new JFrame("Simple Frame");
		frame.setSize(500, 500);
		frame.setLocationRelativeTo(null);
		frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		frame.add(graphComponent, BorderLayout.CENTER);
		frame.setVisible(true);

		graphComponent.fitGraphBounds();
		graphComponent.zoomTo(new PointD(200.0,100.0), graphComponent.getZoom()*2.0);
		
		graphComponent.setInputMode(new GraphEditorInputMode());
	}

	public static void main(String[] args) 
	{
		SwingUtilities.invokeLater(SimpleFrame::new);
	}
}