package demo2018.A_my_demo;

import com.yworks.yfiles.algorithms.Cycles;
import com.yworks.yfiles.algorithms.Edge;
import com.yworks.yfiles.algorithms.Graph;
import com.yworks.yfiles.algorithms.Node;
import com.yworks.yfiles.algorithms.YRandom;

public class RandomTreeGenerator
{    
    /** Instance Variables */
    private int n;
    private YRandom random;
    private Graph tree;
    
    public static void main(String[] args)
    {
    	RandomTreeGenerator randomTree = new RandomTreeGenerator(10);
    	Graph graph = randomTree.generate();
    	System.out.println(graph);
    }
    
    /** 
     * Creates a new instance of RandomTreeGenerator which contains n nodes. 
     * This constructor creates a new object of type Network.
     */
    public RandomTreeGenerator(int n)
    {
        this.n = n;
        tree = new Graph();
        random = new YRandom(System.currentTimeMillis());
    }
    
    /** 
     * Creates a new instance of RandomTreeGenerator which contains n nodes
     * based on the given network. This constructor does not create a new 
     * object of type Network. Instead, it clears the given network and 
     * procides by (randomly) building a new one.
     */
    public RandomTreeGenerator(Graph tree, int n)
    {
        this.n = n;  
        this.tree = tree;
        tree.clear();
        random = new YRandom(System.currentTimeMillis());
    }
    
    
    /**
     * Sets the number of nodes for the generated tree.
     */
    public void setNodeCount(int n)
    {
        this.n = n;
    }
    
    /**
     * Generates a random tree network.
     */
    public Graph generate() 
    {
        Edge edge;
        Node[] nodes = new Node[n];
        
        for (int i=0; i<n; i++) 
        {
            nodes[i] = tree.createNode();
        }
        
        for(int from=0; from<n-1; from++) 
        {
            int to = random.nextInt(n);
            
            boolean created = false;
            edge = tree.createEdge(nodes[from], nodes[to]);
            while (!created) 
            {   
                if (Cycles.findCycle(tree, false).isEmpty()) 
                {
                    created = true;
                }
                else 
                {
                    tree.removeEdge(edge);
                    to = (to+1) % n;
                    edge = tree.createEdge(nodes[from], nodes[to]);
                }
            }
        }
        return tree;
    }    
}