package demo2018.A_my_demo;

import com.yworks.yfiles.algorithms.Edge;
import com.yworks.yfiles.algorithms.Graph;
import com.yworks.yfiles.algorithms.IEdgeCursor;
import com.yworks.yfiles.algorithms.IEdgeMap;
import com.yworks.yfiles.algorithms.INodeCursor;
import com.yworks.yfiles.algorithms.INodeMap;
import com.yworks.yfiles.algorithms.Node;
import com.yworks.yfiles.algorithms.YRandom;

public class ExtendedGraph extends Graph
{
	/**
	 * internal INodeMap that stores additional node data
	 */
	private INodeMap extraNodeData;

	/**
	 * internal IEdgeMap that stores additional edge data
	 */
	private IEdgeMap extraEdgeData;

	/////////////////////////////////////////////////////////////////////////////
	// CONSTRUCTION /////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////

	/** 
	 * Creates a new instance of ExtendedGraph 
	 */
	public ExtendedGraph()
	{
		extraNodeData = createNodeMap();
		extraEdgeData = createEdgeMap();
	}

	/** 
	 * Creates a graph of type ExtendedGraph 
	 */
	public Graph createGraph()
	{
		return new ExtendedGraph();
	}

	/////////////////////////////////////////////////////////////////////////////
	// SETTER AND GETTER ////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////

	/**
	 * Returns the edge weight associated with the given edge.
	 * By default 0 will be returned.
	 */
	public double getEdgeWeight(Edge e)
	{
		return extraEdgeData.getDouble(e);
	}

	/**
	 * Sets the edge weight associated with the given edge.
	 */
	public void setEdgeWeight(Edge e, double weight)
	{ 
		extraEdgeData.setDouble(e, weight);
	}

	/**
	 * Returns the node info associated with the given node.	 *
	 * By default 0 will be returned.
	 */
	public NodeInfo getNodeInfo(Node v)
	{
		NodeInfo info = (NodeInfo)extraNodeData.get(v);

		//default initialisation
		if(info == null)
		{
			info = new NodeInfo();
			setNodeInfo(v, info);
		}

		return info;
	}

	public void setNodeInfo(Node v, NodeInfo info)
	{
		extraNodeData.set(v, info);
	}

	public static class NodeInfo
	{
		public String name;
		public String type;
		public int    version;

		public NodeInfo()
		{
			this("unknown","unknown",0);
		}

		public NodeInfo(String name, String type, int version)
		{
			this.name = name;
			this.type = type;
			this.version = version;
		}

		public String toString()
		{
			return "Name=" + name + "  Type=" + type + "  Version=" + version;
		}
	}

	public static void main(String[] args)
	{
		ExtendedGraph extGraph = new ExtendedGraph();
		RandomGraphGenerator rg = new RandomGraphGenerator(0);
		rg.setNodeCount(10);
		rg.setEdgeCount(10);
		rg.generate(extGraph);
		YRandom random = new YRandom(0);
		for(IEdgeCursor ec = extGraph.getEdgeCursor(); ec.ok(); ec.next())
		{
			extGraph.setEdgeWeight(ec.edge(), random.nextDouble(0.0,10.0));
		}
		for(INodeCursor nc = extGraph.getNodeCursor(); nc.ok(); nc.next())
		{
			Node v = nc.node();
			NodeInfo info = new NodeInfo("Node #" + v.index(),"Extra Node",1);
			extGraph.setNodeInfo(v, info);
		}

		for(INodeCursor nc = extGraph.getNodeCursor(); nc.ok(); nc.next())
		{
			System.out.println(extGraph.getNodeInfo(nc.node()));
		}
		for(IEdgeCursor ec = extGraph.getEdgeCursor(); ec.ok(); ec.next())
		{
			System.out.println("Edge " + ec.edge().index() + " weight= " + extGraph.getEdgeWeight(ec.edge()));
		}

	}
}
