package demo2018.B_my_demo;

import com.yworks.yfiles.algorithms.Cycles;
import com.yworks.yfiles.algorithms.EdgeList;
import com.yworks.yfiles.algorithms.Graph;
import com.yworks.yfiles.algorithms.GraphChecker;
import com.yworks.yfiles.algorithms.GraphConnectivity;
import com.yworks.yfiles.algorithms.IEdgeCursor;
import com.yworks.yfiles.algorithms.Node;
import com.yworks.yfiles.algorithms.Trees;

public class AlgoDemo 
{
    
    public static void main(String args[])
    {
        //instantiates an empty graph
        Graph graph = new Graph();

        //create a temporary node array for fast lookup
        Node tmpNodes[] = new Node[5];

        //create some nodes in the graph and store references in the array
        for(int i = 0; i < 5; i++)
        {
          tmpNodes[i] = graph.createNode();
        }

        //create some edges in the graph
        for(int i = 0; i < 5; i++)
        {
          for(int j = i+1; j < 5; j++)
          {
            //create an edge from node at index i to node at index j
            graph.createEdge(tmpNodes[i],tmpNodes[j]);
          }
        }
        
        EdgeList cycle = Cycles.findCycle(graph, false);
        
        if (cycle.isEmpty())
        {
            System.out.println("It doesn't contains cycles...");
        }
        else 
        {
            System.out.println("It is contains a cycle::");
            for (IEdgeCursor ec = cycle.edges(); ec.ok(); ec.next())
            {
                System.out.print(ec.edge()+" ");
            }
            System.out.println();
        }        
        
        if (GraphConnectivity.isConnected(graph))
        {
            System.out.println("It is connected...");
        }
        else
        {
            System.out.println("It is not connected...");
        }
        
        if (Trees.isTree(graph))
        {
            System.out.println("It is tree...");
        }
        else
        {
            System.out.println("It is not tree...");
        }

        if (GraphChecker.isPlanar(graph))
        {
            System.out.println("It is planar...");
        }
        else
        {
            System.out.println("It is not planar...");
        }
    }    
}
