import java.util.Random;

/**
 * Implements the game of "six chances".
 * The computer chooses a random secret number 
 * in the range [1..100] and the player has 6 chances
 * to figure it out.
 * 
 * @author (Antonios Symvonis) 
 * @version (2 March 2002)
 */
public class SixChances
{
    // instance variables 
    private int secret;
    private int noOfGuesses;
    
    // class variables
    private static Random random=new Random();
    private static int ALLOWED_GUESSES=6;

    /**
     * Constructor for objects of class SixChances
     */
    public SixChances()
    {
        this.newGame();
    }


    /**
     * Starts a new game of "six chances" and prints 
     * instruction on how to play.
     * 
     */
    public void newGame()
    {
        secret =random.nextInt(100)+1;
        noOfGuesses=0;
        System.out.println();
        System.out.println();
        System.out.println("----------------------------------------------------------------------------");
        System.out.println("I have chosen a new secret number in the range [1..100]. ");
        System.out.println("You have 6 chances to guess it.");
        System.out.println();
        System.out.println("Use method \"guess(int)\" to enter your guesses.");
        System.out.println();
    }

    /**
     * Evaluates the guess given as the parameter and prints
     * appropriate messages. Announces the winners and the loosers.
     * 
     * @param  g   The guess of the player.
     */
    public void guess(int g)
    {
        if(g<1 || g>100){
           System.out.println("Out of range...Try a number in [1..1000].");
            return;
        }
        noOfGuesses++;
        if(g==secret){   
            System.out.println("            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            System.out.println("            %                                       %");
            System.out.println("            %           You are a Winner!!!         %");
            System.out.println("            %                                       %");
            System.out.println("            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            System.out.println("Guess-" + noOfGuesses + " was correct! The secret number was " + secret); 
            this.newGame();
            return;
        }
        if (noOfGuesses==ALLOWED_GUESSES) {
            System.out.println();
            System.out.println();
            System.out.println("            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            System.out.println("            %                                       %");
            System.out.println("            %             What a looser!!!          %");
            System.out.println("            %                                       %");
            System.out.println("            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            System.out.print("Guess-" + noOfGuesses + " was wrong! The secret number was " + secret); 
            System.out.println("   Try to win the next game.");
            this.newGame();
            return;
        }
        if (g > secret)
            System.out.println("Guess-" + noOfGuesses + " was wrong! Try a number SMALLER than " + g +".");
        else
            System.out.println("Guess-" + noOfGuesses + " was wrong! Try a number LARGER than " + g +".");   
    }//guess
 
}//class
