
/**
 * Makes conversions between, decimal, binary, octal and Hex
 * representations.
 * 
 * @author (Antonios Symvonis) 
 * @version (21 March 2002)
 */
public class NumberConverter
{


    /**
     * Binary to decimal conversion
     * 
     * @param  binary   a binary number of at most 63 bits.
     * @return     The decimal representation of the parameter 
     */
    public static long bin2Dec(String binary)
    {
        int base=2;
        long decimal=0;
        int coefficient;
        int exponent;

        int degree=binary.length()-1;
        for (int position=0; position<=degree; position++){
            if (binary.charAt(position)=='0')
                coefficient=0;
            else    
                coefficient=1;
            exponent=degree-position;
            decimal=decimal + coefficient * (long) Math.pow(base, exponent);
        }
        return decimal;
    }//bin2Dec


    /**
     * Hexadecimal to decimal conversion
     * 
     * @param  hex   a hexadecimal number of at most 15 digits. 
     * @return     The decimal representation of the parameter 
     */
    public static long hex2Dec(String hex)
    {
        int base=16;
        long decimal=0;
        int coefficient=0;
        int exponent;

        int degree=hex.length()-1;
        for (int position=0; position<=degree; position++){
            switch (hex.charAt(position)){
            case '0': coefficient=0; break;
            case '1': coefficient=1; break;
            case '2': coefficient=2; break;
            case '3': coefficient=3; break;
            case '4': coefficient=4; break;
            case '5': coefficient=5; break;
            case '6': coefficient=6; break;
            case '7': coefficient=7; break;
            case '8': coefficient=8; break;
            case '9': coefficient=9; break;
            case 'A': 
            case 'a':coefficient=10; break;
            case 'B': 
            case 'b':coefficient=11; break;
            case 'C': 
            case 'c':coefficient=12; break;
            case 'D': 
            case 'd':coefficient=13; break;
            case 'E': 
            case 'e':coefficient=14; break;
            case 'F': 
            case 'f':coefficient=15; break;
            }
            exponent=degree-position;
            decimal=decimal + coefficient * (long) Math.pow(base, exponent);
        }
        return decimal;
    }//hex2Dec


    /**
     * Octal to decimal conversion
     * 
     * @param  octal   an octal number of at most 21 digits. 
     * @return     The decimal representation of the parameter 
     */
    public static long oct2Dec(String octal)
    {
        int base=8;
        long decimal=0;
        int coefficient=0;
        int exponent;

        int degree=octal.length()-1;
        for (int position=0; position<=degree; position++){
            switch (octal.charAt(position)){
            case '0': coefficient=0; break;
            case '1': coefficient=1; break;
            case '2': coefficient=2; break;
            case '3': coefficient=3; break;
            case '4': coefficient=4; break;
            case '5': coefficient=5; break;
            case '6': coefficient=6; break;
            case '7': coefficient=7; break;
            }
            exponent=degree-position;
            decimal=decimal + coefficient * (long) Math.pow(base, exponent);
        }
        return decimal;
    }//oct2Dec

    /**
     * Decimal to binary conversion
     * 
     * @param  decimal   a decimal number. 
     * @return     The binary representation of the parameter 
     */
    public static String dec2Bin(long decimal)
    {
        int base=2;
        String binary="";;
        int remainder;
        long quotient;

        boolean finished=false;
        while (!finished){
            remainder= (int) (decimal % base);
            quotient=decimal/base;
            binary= remainder + binary;
            if (quotient==0) 
                finished=true;
            else
                decimal=quotient;
        }
        return binary;
    }//dec2Bin


    /**
     * Decimal to hexadecimal conversion
     * 
     * @param  decimal   a decimal number. 
     * @return     The hexadecimal representation of the parameter 
     */
    public static String dec2Hex(long decimal)
    {
        int base=16;
        String binary="";;
        int remainder;
        long quotient;

        boolean finished=false;
        while (!finished){
            remainder= (int) (decimal % base);
            quotient=decimal/base;
            switch (remainder){
            case 10: binary= "A" + binary;
                     break;     
            case 11: binary= "B" + binary;
                     break;
            case 12: binary= "C" + binary;
                     break; 
            case 13: binary= "D" + binary;
                     break;
            case 14: binary= "E" + binary;
                     break; 
            case 15: binary= "F" + binary;
                     break;            
            default: binary= remainder + binary; //string concatenation        
            }
            if (quotient==0) 
                finished=true;
            else
                decimal=quotient;
        }
        return binary;
    }//dec2Hex

    /**
     * Decimal to octal conversion
     * 
     * @param  decimal   a decimal number. 
     * @return     The octal representation of the parameter 
     */
    public static String dec2Oct(long decimal)
    {
        int base=8;
        String binary="";;
        int remainder;
        long quotient;

        boolean finished=false;
        while (!finished){
            remainder=(int) (decimal % base);
            quotient=decimal/base;
            binary= remainder + binary; //string concatenation        
            if (quotient==0) 
                finished=true;
            else
                decimal=quotient;
        }
        return binary;
    }//dec2Oct


    /**
     * Binary to octal conversion
     * 
     * @param  binary   a binary number of arbitrary length. 
     * @return     The octal representation of the parameter 
     */
    public static String bin2Oct(String binary)
    {
        int blockSize=3;
        String octal="";
        
        /* Add leading zeroes to make the length of the binary
         *  string a multiple of 3.
         */ 
        switch ( binary.length() % blockSize){
            case 0: break;
            case 1: binary= "00" + binary;  break;
            case 2: binary= "0" + binary;   break;
        }

        int processed=0;
        int length;
        String substring;
        length=binary.length();
        while (processed < length){
            substring= binary.substring(processed, processed + blockSize);
            octal=octal + bin2Dec(substring);
            processed=processed+blockSize;
        }
        return octal;
    }//bin2Oct

    /**
     * Binary to hexadecimal  conversion
     * 
     * @param  binary   a binary number of arbitrary length. 
     * @return     The hexadecimal representation of the parameter 
     */
    public static String bin2Hex(String binary)
    {
        int blockSize=4;
        String hex="";

        /* Add leading zeroes to make the length of the binary
         *  string a multiple of 4.
         */ 
        switch ( binary.length() % blockSize){
            case 0: break;
            case 1: binary= "000" + binary;  break;
            case 2: binary= "00" + binary;   break;
            case 3: binary= "0" + binary;    break;
        }

        int processed=0;
        int length;
        String substring;
        length=binary.length();
        while (processed < length){
            substring= binary.substring(processed, processed + blockSize);
            
            hex=hex + dec2Hex(bin2Dec(substring));
            processed=processed+blockSize;
        }
        return hex;
    }//bin2Hex

    /**
     * Octal to binary  conversion
     * 
     * @param  octal   an octal number of arbitrary length. 
     * @return     The binary representation of the parameter 
     */
    public static String oct2Bin(String octal)
    {
        String binary="";
        int length= octal.length(); 
        int processed=0;
        String postfix;

        while (processed < length){
            postfix="";
            switch (octal.charAt(processed)){
                case '0': postfix=postfix + "000"; break;
                case '1': postfix=postfix + "001"; break;
                case '2': postfix=postfix + "010"; break;
                case '3': postfix=postfix + "011"; break;
                case '4': postfix=postfix + "100"; break;
                case '5': postfix=postfix + "101"; break;
                case '6': postfix=postfix + "110"; break;
                case '7': postfix=postfix + "111"; break;
            }
            binary=binary + postfix; //String concatenation
            processed++;
        }

        // Remove leading zeroes. 
        while  (binary.length() >1 && binary.charAt(0)=='0')
             binary=binary.substring(1, binary.length());
        return binary;
    }//oct2Bin

    /**
     * hexadecimal to binary  conversion
     * 
     * @param  hex   a hexadecimal number of arbitrary length. 
     * @return     The binary representation of the parameter 
     */
    public static String hex2Bin(String hex)
    {
        String binary="";
        int length= hex.length(); 
        int processed=0;
        String postfix;

        while (processed < length){
            postfix="";
            switch (hex.charAt(processed)){
                case '0': postfix=postfix + "0000"; break;
                case '1': postfix=postfix + "0001"; break;
                case '2': postfix=postfix + "0010"; break;
                case '3': postfix=postfix + "0011"; break;
                case '4': postfix=postfix + "0100"; break;
                case '5': postfix=postfix + "0101"; break;
                case '6': postfix=postfix + "0110"; break;
                case '7': postfix=postfix + "0111"; break;
                case '8': postfix=postfix + "1000"; break;
                case '9': postfix=postfix + "1001"; break;
                case 'a':
                case 'A': postfix=postfix + "1010"; break;
                case 'b':
                case 'B': postfix=postfix + "1011"; break;
                case 'c':
                case 'C': postfix=postfix + "1100"; break;
                case 'd':
                case 'D': postfix=postfix + "1101"; break;
                case 'e':
                case 'E': postfix=postfix + "1110"; break;
                case 'f':
                case 'F': postfix=postfix + "1111"; break;
            }
            binary=binary + postfix; //String concatenation
            processed++;
        }

        // Remove leading zeroes.         
        while  (binary.length() >1 && binary.charAt(0)=='0')
             binary=binary.substring(1, binary.length());
        return binary;
    }//hex2Bin

}
