import java.util.Random;
/**
 * Class Matrix provides several static operation
 * on 2-dimensional arrays of double. The methods of class
 * Matrix can operate correctly on 2 dimensional arrays which
 * are rectangular (all rows  are of equal length) and
 * non-empty (not null and minimum size double[1][1]).
 * 
 * @author (Antonios Symvonis) 
 * @version (18 April 2002)
 */
public class Matrix
{
    /**
     * Prints the elements of a 2d-array, each row at a different line.
     * 
     * @param  m    The array of which the ellements are printed. 
     *              Must be rectangular and non-empty.
     */   
    public static void print(double m[][])
    {
        int rows=m.length;
        int cols=m[0].length;
        
        for( int i=0; i<rows; i++){
            for (int j=0; j<cols; j++)
                System.out.print(m[i][j] +"  ");
            System.out.println();
        }
        System.out.println();
    }//print

    /**
     * Creates an exact copy of a 2d-array.
     * 
     * @param  m    The array to be copied. Must be rectangular and non-empty.
     * @return      An exact copy of the argument array.
     */
    public static double[][] clone(double m[][])
    {
        int rows=m.length;
        double result[][]=new double[rows][];
        
        for(int i=0; i<rows; i++){
            int cols=m[i].length;
            result[i] = new double[cols];
            for(int j=0; j<cols; j++)
                result[i][j]=m[i][j];
        }
        return result;
    }//clone


    /**
     * Fills a  matrix with radmon data in the range [0..1). The random
     * numbers have precision of 2 decimal digits. 
     *
     * @param  m        The  array to be filled. Must be rectangular and non-empty.
     */
    public static void fillRandomData(double m[][])
    {
        Random random= new Random(0);
        int rows=m.length;
        int cols=m[0].length;
        
        for (int i=0; i<rows; i++)
            for (int j=0; j<cols; j++)
                m[i][j]=(double) random.nextInt(100)/100;
    }//fillRandomData



}//Matrix
