import java.util.Random;
/**
 * Class LinearArray provides several static operation
 * on linear arrays of double. Methods add(), subtract()
 * multiply() and clone() return a new array, while
 * method fillRandomData() modifies the array that is passed 
 * as an argument to them.
 * 
 * @author (Antonios Symvonis) 
 * @version (11 April 2002)
 */
public  class LinearArray
{
    /**
     * Fills a  linear array with radmon data in the range [0..1). The random
     * numbers have precision of 2 decimal digits. 
     *
     * @param  a        The  array to be filled. It cannot be NULL.
     * @return          The result of the multiplication.
     */
    public static void fillRandomData(double a[])
    {
        Random random= new Random(0);
        int len=a.length;

        for (int i=0; i< len; i++)
            a[i]= (double) random.nextInt(100)/100;
    }//fillRandomData

    /**
     * Prints the elements of an array, all at the same line.
     * 
     * @param  a   The array of which the ellements are printed.
     */   
    public static void printH(double a[])
    {
        int len=a.length;
        System.out.print("{");
        for( int i=0; i< len-1; i++)
            System.out.print(a[i] + ", " );
        System.out.println(a[len-1] +"}");
    }//printH


    /**
     * Prints the elements of an array, each at a different line.
     * 
     * @param  a   The array of which the ellements are printed.
     */   
    public static void printV(double a[])
    {
        int len=a.length;
        for( int i=0; i< len; i++)
            System.out.println(a[i]);
        System.out.println();
    }//printV


    /**
     * Creates an exact copy of an array.
     * 
     * @param  a    The array to be copied. It cannot be NULL.
     * @return      An exact copy of the argument array.
     */
//    public static double[] clone(double original[])
//    {
                 //****insert your code here.   
//    }//clone



    /**
     * Implements linear array addition. The two arrays to be added must be of 
     * equal length. 
     *
     * @param  a1    The first array to be added. It cannot be NULL.
     * @param  a2    The second array to be added. It cannot be NULL.
     * @return       The sum of the argument arrays.
     */
//    public static double[] add(double a1[], double a2[])
//    {
                //****insert your code here. 
//    }//add



    /**
     * Implements linear array subtraction. The two arrays which participate  must be of 
     * equal length. 
     *
     * @param  a1    The  array from which we subtract. It cannot be NULL.
     * @param  a2    The  array to be subtracted. It cannot be NULL.
     * @return       The result of the subtraction.
     */
//    public static double[] subtract(double a1[], double a2[])
//    {
                //****insert your code here.
//    }//subtract


    /**
     * Implements scalar linear array multiplication. 
     *
     * @param  factor   The  factor of the multiplication.
     * @param  a        The  array to be multiplied. It cannot be NULL.
     * @return          The result of the multiplication.
     */
//    public static double[] multiply(double factor, double a[])
//    {
                //****insert your code here.
//    }//multiply


    /**
     * Starting from a specified position of an array, it identifies the 
     * location of the maximum element of the array. The specified position is 
     * included in the search.
     * 
     * @param  a        The array to be searched.
     * @param  start    The search for the maximum starts from this position.
     * @return          The index of the maximum element.
     */
//    public static int maxLocationFrom(double a[], int start)
//    {
                //****insert your code here.
//    }//maxLocationFrom


    /**
     * Starting from a specified position of an array, it identifies the 
     * location of the minimum element of the array. The specified position is 
     * included in the search.
     * 
     * @param  a        The array to be searched.
     * @param  start    The search for the minimum starts from this position.
     * @return          The index of the minimum element.
     */
//    public static int minLocationFrom(double a[], int start)
//    {
                //****insert your code here.
//    }//minLocationFrom


}
