import java.util.*;
/**
 * Implements a generic set as a Linked List. "Equal elements are not allowed  in the set. Element
 * equality is test with method equals() of class Object (possibly redefined). 
 * The class does not support the forEach loop since it does not implement interface Iterable.
 * The example demonstrates the use of inner classes and the implementation of iterators
 * 
 * @author (Antonis Symvonis) 
 * @version (17 December 2017)
 */
public class MyLLSet<E> 
{
    
    private LLNode<E> head;        //The head of the List.
    private int size;              //The cardinality of the set.
    
    /** 
     * Creates a new instance of MyLLSet 
     */
    public MyLLSet() 
    {
        head = null;
        size = 0;
    }
    
    /**
     * Determines if the set is empty.
     */
    public boolean isEmpty() 
    {
        return (size == 0);
    }
        
    /**
     * Returns the cardinality of the set.
     */
    public int size() 
    {
        return size;
    }
    
    /**
     * Determines if the set contains a given element.
     */
    public boolean isIn(E element) 
    {
        LLNode temp = head;
        while (temp!=null) 
        {
            if(element.equals(temp.getElement())) 
                return true;
            temp = temp.getNext();
        }
        return false;
    }
    
    /**
     * Adds an element in the set (if it's not already in).
     */
    public void add(E element)
    {
        if (!isIn(element))
        {
            LLNode newNode = new LLNode();
            newNode.setElement(element);
            newNode.setNext(head);
            head = newNode;
            size++;
        }
    }
    
    /**
     * Removes and return an element from the set. It assumes that the element is in the Set
     */
    public void remove(E element)
    {
        LLNode previous = null;
        LLNode finger = head;
        
        while ((finger!= null) && (!element.equals(finger.getElement()))) 
        {
            previous = finger;
            finger = finger.getNext();
        }
        
        if (finger==head) 
            if (size==1) //we delete the only element
                head=null;
            else 
                head=finger.getNext();
        else 
            previous.setNext(finger.getNext());
        size--;
    }
    
    /**
     * Returns an iterator for this collection.
     */
    public Iterator<E> iterator()
    {
        return new MyLLIterator();
    }
    
    
    
    /**
     * Inner class. Implements a linked list node. 
     */
    private class LLNode<E>
    {
        private E element;
        private LLNode<E> next;
        
        /** 
         * Creates a new instance of LLNode. 
         */
        public LLNode(){}
        
        /** 
         * Sets the data of the node.
         */
        public void setElement(E element)
        {
            this.element = element;
        }
        
        /** 
         * Returns the data of the node.
         */
        public E getElement()
        {
            return element;
        }
        
        /** 
         * Sets the next node.
         */
        public void setNext(LLNode<E> next)
        {
            this.next = next;
        }
        
        /** 
         * Returns the next node.
         */
        public LLNode<E> getNext()
        {
            return next;
        }
    }//LLNode 
    

    /**
     * This class demostrates an iterator for this set.
     */
    private class MyLLIterator implements Iterator<E>
    {
        private LLNode<E> nextNode;
  
        MyLLIterator()
        {
            nextNode=head;
        }
        /**
         * Determines if is has therer exist next element
         */
        public boolean hasNext()
        {    
                return (nextNode!=null);         
        }
        
        /**
         * Returns the next object of the list.
         */        
        public E next()
        {
            E element = nextNode.getElement();
            nextNode = nextNode.getNext();
            return   element;
        }
        /**
         * It is not implemented.
         */
        public void remove(){}       
    }//MyLLIterator    
}
