
/**
 * Class Counter implements a simple counter.
 * 
 * @author Antonios Symvonis
 * @version v1.0, February 11, 2002
 */
public class Counter
{
    // instance variables - replace the example below with your own
    private int value;

    /**
     * Set the initial value of the counter to zero
     */
    public Counter()
    {
        // initialise instance variables
        value = 0;
    }

    /**
     * Set the initial value of the counter to a given value
     * @param  initialValue   the initial value of the counter
     */
    public Counter(int initialValue)
    {
        // initialise instance variables
        value= initialValue;
    }

    /**
     * Resets the counter to Zero
     *
     */
    public void reset()
    {
        value=0;
    }


    /**
     * Provides access to the value of the counter
     *
     * @return     The value of the counter 
     */
    public int getValue()
    {
        return value;
    }

    /**
     * Sets the  counter to a new value
     *
     * @param  newValue   The new value of the counter
     */
    public void setValue(int newValue)
    {
        value=newValue;
    }


    /**
     * Increments  the  counter by a given  value
     *
     * @param  inc   The value the counter is incremented by.
     */
    public void incrementBy(int inc)
    {
        value= value + inc;
    }

    /**
     * Increments  the  counter by one
     *
     */
    public void increment()
    {
        value= value + 1;
    }

    /**
     * Decrements  the  counter by a given  value
     *
     * @param  dec   The value the counter is decremented by.
     */
    public void decrementBy(int dec)
    {
        value= value - dec;
    }

    /**
     * Decrements  the  counter by one
     *
     */
    public void decrement()
    {
        value= value - 1;
    }

}
