import java.io.*;

/**
 * This class contains static methods for serializing and deserializing objects 
 * into files. The objects which will be serialized should implement the
 * java.io.Serializable interface.
 * 
 * @author Michael Bekos and Antonios Symvonis 
 * @version 13 June 2004
 */
public class FileLoader
{

    /**
     * Deserializes an object from the specified file. If the given file does 
     * not exist or it is a directory  it returns null.
     * 
     * @param  inputFile  The file which contains the object to get deseraliased.
     * 
     */
    public static Object deserializeFromFile(File inputFile) throws IOException, ClassNotFoundException
    {
        Object returnValue = null;

        if (inputFile.exists())
        {
            if (inputFile.isFile())
            {
                ObjectInputStream readIn = new ObjectInputStream(new FileInputStream(inputFile));
                returnValue = readIn.readObject();
                readIn.close();
            }
            else
            {
                System.err.println(inputFile + " is a directory.");
            }
        }
        else
        {
            System.err.println("File " + inputFile + " does not exist.");
        }
        
        return returnValue;
    }
    
    /**
     * Serializes an object to the specified file.
     * 
     * @param  outputFile  The file to which we store the selializes   object.
     * @param  data  The object to be deseraliased.
     */
    public static void serializeToFile(File outputFile, Serializable data)
    throws IOException
    {
        ObjectOutputStream writeOut = new ObjectOutputStream(new FileOutputStream(outputFile));
        writeOut.writeObject(data);
        writeOut.close();
    }
}