
import java.util.ArrayList;
import java.util.Iterator;
import java.io.*;
/**
 * A toy-database of contacts. Its purpose is to demonstrate the use of serialization.
 * 
 * @author Michael Bekos and Antonios Symvonis 
 * @version 27 December 2018
 */
public class ContactDatabase
{
    
    private ArrayList<Contact> contactList;  //This object implements Serializable
    
    /**
     * Creates a new instance of ContactDatabase instantiating an empty
     * arraylist.
     */
    public ContactDatabase()
    {
        this.contactList = new ArrayList<>();
    }
    
    /**
     * Determines if the contact list is empty.
     */
    public boolean isEmpty()
    {
        return contactList.isEmpty();
    }
    
    /**
     * Returns the total number of contacts.
     */
    public int getNoOfContacts()
    {
        return contactList.size();
    }
    
    /**
     * Adds a new contact to the list.
     */
    public void addContact(Contact contact)
    {
        contactList.add(contact);
    }
    
    /**
     * Saves the contact list to the specified file.
     */
    public void saveContactList(String fileName)
    {
        try
        {
            File file = new File(fileName);
            FileLoader.serializeToFile(file, contactList);
        }
        catch (IOException exc)
        {
            System.err.println("An error occured while saving this file.");
        }
    }
    
    /**
     * Loads a contact list from the specified file.
     */
    public void loadContactList(String fileName)
    {
        try
        {
            File file = new File(fileName);
            this.contactList = (ArrayList<Contact>) FileLoader.deserializeFromFile(file);
        }
        catch (IOException exc)
        {
            System.err.println("An error occured while loading this file.");
        }
        catch (ClassNotFoundException exc)
        {
            System.err.println("An error occured while loading this file.");
        }
    }
    
    /**
     * Returns a string representation of the contact database.
     */
    public String toString()
    {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator it = contactList.iterator();
        while(it.hasNext())
        {
            stringBuffer.append((it.next()).toString()).append("\n\n");
            
        }
        return stringBuffer.toString();
    }
    
    public void print()
    {
        System.out.println(this);
    }
    
}
