import java.io.Serializable;
/**
 * Contact objects are inserted into a toy-database of contacts.
 * 
 * @author Michael Bekos and Antonios Symvonis 
 * @version 13 June 2004
 */
public class Contact implements Serializable
{
    private String firstName;
    private String lastName;
    private int phoneNumber;
    
    /** 
     * Creates a new instance of Contact 
     */
    public Contact(){}
    
    /** 
     * Creates a new instance of Contact 
     * 
     * @param  firstName   The first name of a contact
     * @param  lastName    The last name of a contact
     * @param  phoneNumber The phone number of a contact
     */
    public Contact(String firstName, String lastName, int phoneNumber)
    {
        this.firstName = firstName;
        this.lastName = lastName;
        this.phoneNumber = phoneNumber;
    }
    
    /**
     * Sets the first name of the Contact.
     * 
     * @param  firstName   The first name of a contact
     */
    public void setFirstName(String firstName)
    {
        this.firstName = firstName;
    }
    
    /**
     * Sets the last name of the Contact.
     * 
     * @param  lastName    The last name of a contact
     */
    public void setLastName(String lastName)
    {
        this.lastName = lastName;
    }
    
    /**
     * Sets the phone number of the Contact.
     * 
     * @param  phoneNumber The phone number of a contact
     */
    public void setPhoneNumber(int phoneNumber)
    {
        this.phoneNumber = phoneNumber;
    }
    
    /**
     * Returns the firstname of the Contact.
     */
    public String getFirstName()
    {
        return firstName;
    }
    
    /**
     * Returns the lastname of the Contact.
     */
    public String getLastName()
    {
        return lastName;
    }
    
    /**
     * Returns the phoneNumber of the person.
     */
    public int getPhoneNumber()
    {
        return phoneNumber;
    }
    
    /**
     * Returns a string representation of this object.
     */
    public String toString()
    {
        return new StringBuffer().append("Firstname: ")
                                 .append(firstName)
                                 .append("\nLastName: ")
                                 .append(lastName)
                                 .append("\nPhone Number: ")
                                 .append(phoneNumber)
                                 .toString();
    }   
}
