/**
 * A singly connected linked list of int.
 * The elements of the lists are stored in Cell objects.
 * The implementation contains the Cell variables head and tail
 * which refer the the front and back elements of the list, respectively.
 * For direct access, the numbering of the elements starts from zero(0).
 * 
 * @author Antonios Symvonis 
 * @version 14 May 2002
 */
public class IntList
{
    // instance variables - replace the example below with your own
    private Cell head;      //the front of the list
    private Cell tail;      //the back of the list
    private int noOfElems;  //the number of elements of the list

    /**
     * Creates a new empty list.
     */
    public IntList()
    {
        head=null;
        tail=null;
        noOfElems=0;
    }

    /**
     * The size of the list.
     * 
     * @return     The number of elements in the list.
     */   
    public int size()
    {
        return noOfElems;
    }//size


    /**
     * Inserts a new element at the back of the list.
     * 
     * @param y     The elements to be inserted.
     */   
    public void insertBack(int y)
    {
        Cell cell=new Cell(y);
        

        if ( noOfElems==0){
            head=cell;
            tail=cell;
        } 
        else{
            tail.setNext(cell);
            tail=cell;
        }

        noOfElems++;
    }//insetBack

    /**
     * Deletes the element at the front of the list.
     * 
     * @return      The (deleted) front element of the list.
     */   
    public int deleteFront()
    {
        int value=head.getData();
        
        if (this.size()==1){
            head=null;
            tail=null;
        }
        else{
            Cell temp=head;
            head=head.getNext();
            temp.setNext(null);
        }

        noOfElems--;
        return value;
    }//deleteFront

    /**
     * Checks whether the list is empty.
     * 
     * @return      True if the list is empty, false otherwise.
     */   
    public boolean isEmpty()
    {
        return (noOfElems==0);
    }//isEmpty

    /**
     * Prints the elements of the list
     * 
     */   
    public void print()
    {
        System.out.print("(");
        
        Cell item=head;
        while (item!=null) {
            System.out.print(item.getData());
            if (item.getNext()!=null)
                System.out.print(", ");
            item=item.getNext();
        }
        System.out.println(")");        
    }//print
    
    /**
     * Checks whether a given element is in the list and, if it is, returns the 
     * position (index) of its first occurence.
     * 
     * @param   key   The element to search for.
     * @return       The location of the key element, -1 if key is not in the list.
     */   
    public int locate(int key)
    {
        boolean found=false;
        int location =0;

        
        Cell item=head;
        while (item!=null & !found) {
            if (item.getData()==key)
                found=true;
            else {
                location++;
                item=item.getNext();
            }
        }

        if (found) 
            return location;
        else
            return -1; 
    }//locate

     /**
     * Accesses the element at a given location. 
     * The accessed element must exist.
     * 
     * 
     * @param   location   The location to be accessed. It must hold that 0<= location <= size()-1.
     * @return       The element at location.
     */   
    public int dataAt(int location)
    {
        Cell item=head;
        for (int i=0; i<location; i++)
            item=item.getNext();

        return item.getData();
    }//valueAt


     /**
     * Deletes the element at a given location. 
     * The  element must exist.
     * 
     * 
     * @param   location   The location of the element to be deleted. It must hold that 0<= location <= size()-1.
     * @return       The deleted element.
     */   
    public int deleteFrom(int location)
    {
        int value;
        Cell item;
        Cell previous;

        if (location==0)
            value=this.deleteFront();
        else{
            previous=head;
            for (int i=0; i<location-1; i++)
                previous=previous.getNext();

            item=previous.getNext();
            
            previous.setNext(item.getNext());
            if (previous.getNext()==null)
                tail=previous;

            value=item.getData();
            item.setNext(null);         
        }
        return value;
    }//deletaAt



     /**
     * Inserts a new  element. The element after insertion is at  location pos. 
     * The position of the insertion must fall within the list.
     * 
     * 
     * @param   pos   The location of the new element after insertion. It must hold that 0<= pos <= size().
     * @param   y     The new element
     */   
    public void insertAt(int pos, int y)
    {
        Cell cell=new Cell(y);
        Cell previous;
        if (pos==0){
            cell.setNext(head);
            head=cell;
            if (noOfElems==0)
                tail=cell;
        }
        else {
            previous=head;
            for (int i=0; i<pos-1; i++)
                previous=previous.getNext();
            cell.setNext(previous.getNext());
            previous.setNext(cell);
            if (noOfElems==pos)
                tail=cell;
        }
        noOfElems++;
    }//insertAt


     /**
     * Updates the value of the element at a given position. 
     * The element to be updated must exist.
     * 
     * @param   pos   The location of the update. It must hold that 0 <= pos <= size()-1.
     * @param   newValue     The new value
     */   
    public void update(int pos, int newValue)
    {
        Cell cell=head;

        for (int i=0; i<pos; i++)
            cell=cell.getNext();
        cell.setData(newValue);
    }//insertAt

}//IntList
