
/**
 * Implements a cell of a simple linked list.
 * It stores one value of type int and the next cell
 * in the list.
 * 
 * @author Antonios Symvonis 
 * @version 14 May 2002
 */
public class Cell
{
    
    private int data;
    private Cell next;

    /**
     * Constructor for objects of class Cell.
     * Sets the data by default to zero (0)
     */
    public Cell()
    {
        data = 0;
        next =null;
    }//Cell


    /**
     * Constructor for objects of class Cell.
     * The value of the cell is provided as a parameter
     *
     *@param v The data of the new cell
     */
    public Cell(int value)
    {
        data = value;
        next =null;
    }//Cell

    /**
     * Updates the value of a cell
     * 
     * @param  newData   The new data of the cell
     */
    public void setData(int newData)
    {
        data=newData;
    }//setValue

    /**
     * Sets the cell that follows the current one in the list
     * 
     * @param  newNext   The next cell
     */    
    public void setNext(Cell newNext)
    {
        next=newNext;
    }//setNext

    /**
     * Accesses the value of a cell
     * 
     * @return  The data  of the cell
     */    
    public int getData()
    {
        return data;
    }//getValue

    /**
     * Accesses the cell that follows the current one
     * 
     * @return  The next cell
     */   
    public Cell getNext()
    {
        return next;
    }//getNext
}//class Cell
