//file: TerribleFlicker.java
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class TerribleFlicker extends JComponent
                             implements MouseMotionListener {
  int grid = 10;
  int imageX, imageY;
  Image image;
  int imageWidth = 60, imageHeight = 60;

  public TerribleFlicker(Image i) {
    image = i;
    addMouseMotionListener(this);
  }

  public void mouseDragged(MouseEvent e) {
    imageX = e.getX(  );
    imageY = e.getY(  );
    repaint(  );
  }

  public void mouseMoved(MouseEvent e) {}

  public void paint(Graphics g) {
    Graphics2D g2 = (Graphics2D)g;

    int w = getSize(  ).width / grid;
    int h = getSize(  ).height / grid;
    boolean black = false;
    for (int y = 0; y <= grid; y++)
      for (int x = 0; x <= grid; x++) {
        g2.setPaint(black ? Color.black : Color.white);
        black = !black;
        g2.fillRect(x * w, y * h, w, h);
      }
    g2.drawImage(image, imageX, imageY,
                 imageWidth, imageHeight, this);
  }

  public static void main(String[] args) {
    String imageFile = "L1-Light.jpg";
    if (args.length > 0)
      imageFile = args[0];
    Image i = Toolkit.getDefaultToolkit(  ).getImage(
        TerribleFlicker.class.getResource(imageFile));
    JFrame f = new JFrame("TerribleFlicker");
    Container content = new Panel(new BorderLayout(  ));
    content.add(new TerribleFlicker(i), BorderLayout.CENTER);
    f.setContentPane(content);
    f.setSize(300, 300);
    f.setLocation(100, 100);
    f.addWindowListener(new WindowAdapter(  ) {
      public void windowClosing(WindowEvent e) { System.exit(0); }
    });
    f.setVisible(true);
  }
}
