//file: LimitedFlicker.java
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class LimitedFlicker extends TerribleFlicker {
  int oldX, oldY;

  public LimitedFlicker(Image i) { super(i); }

  public void mouseDragged(MouseEvent e) {
    imageX = e.getX(  );
    imageY = e.getY(  );
    Rectangle r = getAffectedArea(oldX, oldY, imageX, imageY,
        imageWidth, imageHeight);
    // update just the affected part of the component
    repaint(r);
    oldX = imageX;
    oldY = imageY;
  }

  private Rectangle getAffectedArea(int oldx, int oldy,
      int newx, int newy, int width, int height) {
    int x = Math.min(oldx, newx);
    int y = Math.min(oldy, newy);
    int w = (Math.max(oldx, newx) + width) - x;
    int h = (Math.max(oldy, newy) + height) - y;
    return new Rectangle(x, y, w, h);
  }

  public static void main(String[] args) {
    String imageFile = "L1-Light.jpg";
    if (args.length > 0)
      imageFile = args[0];
    Image i = Toolkit.getDefaultToolkit(  ).getImage(
        TerribleFlicker.class.getResource(imageFile));
    JFrame f = new JFrame("LimitedFlicker");
    Container content = new Panel(new BorderLayout(  )) {
        public void update(Graphics g) { paint(g); }
    };
    content.add(new LimitedFlicker(i), BorderLayout.CENTER);
    f.setContentPane(content);
    f.setSize(300, 300);
    f.setLocation(100, 100);
    f.addWindowListener(new WindowAdapter(  ) {
      public void windowClosing(WindowEvent e) { System.exit(0); }
    });
    f.setVisible(true);
  }
}
