//file: CanisMinor.java
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import javax.swing.*;
import javax.swing.event.*;

public class CanisMinor extends JFrame {
  protected JEditorPane mEditorPane;
  protected JTextField mURLField;

  public CanisMinor(String urlString) {
    super("CanisMinor v1.0");
    createUI(urlString);
    setVisible(true);
  }

  protected void createUI(String urlString) {
    setSize(500, 600);
    center(  );
    Container content = getContentPane(  );
    content.setLayout(new BorderLayout(  ));

    // add the URL control
    JToolBar urlToolBar = new JToolBar(  );
    mURLField = new JTextField(urlString, 40);
    urlToolBar.add(new JLabel("Location:"));
    urlToolBar.add(mURLField);
    content.add(urlToolBar, BorderLayout.NORTH);

    // add the editor pane
    mEditorPane = new JEditorPane(  );
    mEditorPane.setEditable(false);
    content.add(new JScrollPane(mEditorPane), BorderLayout.CENTER);

    // open the initial URL
    openURL(urlString);

    // go to a new location when enter is pressed in the URL field
    mURLField.addActionListener(new ActionListener(  ) {
      public void actionPerformed(ActionEvent ae) {
        openURL(ae.getActionCommand(  ));
      }
    });

    // add the plumbing to make links work
    mEditorPane.addHyperlinkListener(new LinkActivator(  ));

    // exit the application when the window is closed
    addWindowListener(new WindowAdapter(  ) {
      public void windowClosing(WindowEvent e) { System.exit(0); }
    });
  }

  protected void center(  ) {
    Dimension screen = Toolkit.getDefaultToolkit().getScreenSize(  );
    Dimension us = getSize(  );
    int x = (screen.width - us.width) / 2;
    int y = (screen.height - us.height) / 2;
    setLocation(x, y);
  }

  protected void openURL(String urlString) {
    try {
      URL url = new URL(urlString);
      mEditorPane.setPage(url);
      mURLField.setText(url.toExternalForm(  ));
    }
    catch (Exception e) {
      System.out.println("Couldn't open " + urlString + ":" + e);
    }
  }

  class LinkActivator implements HyperlinkListener {
    public void hyperlinkUpdate(HyperlinkEvent he) {
      HyperlinkEvent.EventType type = he.getEventType(  );
      if (type == HyperlinkEvent.EventType.ENTERED)
        mEditorPane.setCursor(
            Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
      else if (type == HyperlinkEvent.EventType.EXITED)
        mEditorPane.setCursor(Cursor.getDefaultCursor(  ));
      else if (type == HyperlinkEvent.EventType.ACTIVATED)
        openURL(he.getURL().toExternalForm(  ));
    }
  }

  public static void main(String[] args) {
    String urlString = "http://www.oreilly.com/catalog/java2d/";
    if (args.length > 0)
       urlString = args[0];
    new CanisMinor(urlString);
  }
}
