//file: SplitPaneFrame.java
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

public class SplitPaneFrame {
  public static void main(String[] args) {
    String fileOne = "Piazza di Spagna.jpg";
    String fileTwo = "L1-Light.jpg";

    if (args.length > 0) fileOne = args[0];
    if (args.length > 1) fileTwo = args[1];

    // create a JFrame to hold everything
    JFrame f = new JFrame("SplitPaneFrame");
    f.addWindowListener(new WindowAdapter(  ) {
      public void windowClosing(WindowEvent we) { System.exit(0); }
    });
    f.setSize(300, 200);
    f.setLocation(200, 200);

    Image leftImage = Toolkit.getDefaultToolkit(  ).getImage(fileOne);
    Component left =
      new JScrollPane(new ImageComponent(leftImage));
    Image rightImage = Toolkit.getDefaultToolkit(  ).getImage(fileTwo);
    Component right =
      new JScrollPane(new ImageComponent(rightImage));
    JSplitPane split =
      new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, left, right);
    split.setDividerLocation(100);
    f.getContentPane(  ).add(split);

    f.setVisible(true);
  }
}
