//file: Slippery.java
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class Slippery extends JFrame {

  public Slippery(  ) {
    super("Slippery v1.0");
    setSize(220, 160);
    setLocation(200, 200);

    Container content = getContentPane(  );

    JPanel main = new JPanel(new GridLayout(2, 1));
    JPanel scrollBarPanel = new JPanel(  );
    final JScrollBar scrollBar =
        new JScrollBar(JScrollBar.HORIZONTAL, 0, 48, 0, 255);
    int height = scrollBar.getPreferredSize(  ).height;
    scrollBar.setPreferredSize(new Dimension(175, height));
    scrollBarPanel.add(scrollBar);
    main.add(scrollBarPanel);

    JPanel sliderPanel = new JPanel(  );
    final JSlider slider =
        new JSlider(JSlider.HORIZONTAL, 0, 255, 128);
    slider.setMajorTickSpacing(48);
    slider.setMinorTickSpacing(16);
    slider.setPaintTicks(true);
    sliderPanel.add(slider);
    main.add(sliderPanel);

    content.add(main, BorderLayout.CENTER);

    final JLabel statusLabel =
        new JLabel("Welcome to Slippery v1.0");
    content.add(statusLabel, BorderLayout.SOUTH);

    // wire up the event handlers
    scrollBar.addAdjustmentListener(new AdjustmentListener(  ) {
      public void adjustmentValueChanged(AdjustmentEvent e) {
        statusLabel.setText("JScrollBar's current value = "
                            + scrollBar.getValue(  ));
      }
    });

    slider.addChangeListener(new ChangeListener(  ) {
      public void stateChanged(ChangeEvent e) {
        statusLabel.setText("JSlider's current value = "
                            + slider.getValue(  ));
      }
    });
  }

  public static void main(String[] args) {
    JFrame f = new Slippery(  );
    f.addWindowListener(new WindowAdapter(  ) {
      public void windowClosing(WindowEvent e) { System.exit(0); }
    });
    f.setVisible(true);
  }
}
