//file: ScrollPaneFrame.java
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class ScrollPaneFrame {
  public static void main(String[] args) {
    String filename = "Piazza di Spagna.jpg";
    if (args.length > 0)
      filename = args[0];

    JFrame f = new JFrame("ScrollPaneFrame v1.0");
    f.setSize(300, 300);
    f.setLocation(200, 200);
    f.addWindowListener(new WindowAdapter(  ) {
      public void windowClosing(WindowEvent e) { System.exit(0); }
    });
    

    Image image = Toolkit.getDefaultToolkit(  ).getImage(filename);
    f.getContentPane(  ).add(
      new JScrollPane(new ImageComponent(image)));
    f.setVisible(true);
  }
}
