//file: PopUpColorMenu.java
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class PopUpColorMenu extends JFrame
                            implements ActionListener {
  JPopupMenu colorMenu;
  Component selectedComponent;

  public PopUpColorMenu(  ) {
    super("PopUpColorMenu v1.0");
    setSize(100, 200);
    setLocation(200, 200);
    addWindowListener(new WindowAdapter(  ) {
      public void windowClosing(WindowEvent e) { System.exit(0); }
    });

    MouseListener mouseListener = new MouseAdapter(  ) {
      public void mousePressed(MouseEvent e) { checkPopup(e); }
      public void mouseClicked(MouseEvent e) { checkPopup(e); }
      public void mouseReleased(MouseEvent e) { checkPopup(e); }
      private void checkPopup(MouseEvent e) {
        if (e.isPopupTrigger(  )) {
          selectedComponent = e.getComponent(  );
          colorMenu.show(e.getComponent(), e.getX(), e.getY(  ));
        }
      }
    };

    final Container content = getContentPane(  );
    content.setLayout(new FlowLayout(  ));
    JButton button = new JButton("Uno");
    button.addMouseListener(mouseListener);
    content.add(button);
    button = new JButton("Due");
    button.addMouseListener(mouseListener);
    content.add(button);
    button = new JButton("Tre");
    button.addMouseListener(mouseListener);
    content.add(button);

    colorMenu = new JPopupMenu("Color");
    colorMenu.add(makeMenuItem("Red"));
    colorMenu.add(makeMenuItem("Green"));
    colorMenu.add(makeMenuItem("Blue"));

    getContentPane(  ).addMouseListener(mouseListener);

    setVisible(true);
  }

  public void actionPerformed(ActionEvent e) {
    String color = e.getActionCommand(  );
    if (color.equals("Red"))
      selectedComponent.setBackground(Color.red);
    else if (color.equals("Green"))
      selectedComponent.setBackground(Color.green);
    else if (color.equals("Blue"))
      selectedComponent.setBackground(Color.blue);
  }

  private JMenuItem makeMenuItem(String label) {
    JMenuItem item = new JMenuItem(label);
    item.addActionListener( this );
    return item;
  }

  public static void main(String[] args) {
    new PopUpColorMenu(  );
  }
}
