//file: Borders.java
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

public class Borders {
  public static void main(String[] args) {
    // create a JFrame to hold everything
    JFrame f = new JFrame("Borders");
    f.addWindowListener(new WindowAdapter(  ) {
      public void windowClosing(WindowEvent we) { System.exit(0); }
    });
    f.setSize(300, 300);
    f.setLocation(200, 200);

    // Create labels with borders.
    int center = SwingConstants.CENTER;
    JLabel labelOne = new JLabel("raised BevelBorder", center);
    labelOne.setBorder(
        BorderFactory.createBevelBorder(BevelBorder.RAISED));
        
    JLabel labelTwo = new JLabel("EtchedBorder", center);
    labelTwo.setBorder(BorderFactory.createEtchedBorder(  ));
    
    JLabel labelThree = new JLabel("MatteBorder", center);
    labelThree.setBorder(
        BorderFactory.createMatteBorder(10, 10, 10, 10, Color.pink));
        
    JLabel labelFour = new JLabel("TitledBorder", center);
    Border etch = BorderFactory.createEtchedBorder(  );
    labelFour.setBorder(
        BorderFactory.createTitledBorder(etch, "Title"));
        
    JLabel labelFive = new JLabel("TitledBorder", center);
    Border low = BorderFactory.createLoweredBevelBorder(  );
    labelFive.setBorder(
        BorderFactory.createTitledBorder(low, "Title",
        TitledBorder.RIGHT, TitledBorder.BOTTOM));
        
    JLabel labelSix = new JLabel("CompoundBorder", center);
    Border one = BorderFactory.createEtchedBorder(  );
    Border two =
        BorderFactory.createMatteBorder(4, 4, 4, 4, Color.blue);
    labelSix.setBorder(BorderFactory.createCompoundBorder(one, two));

    // add components to the content pane
    Container c = f.getContentPane(  );
    c.setLayout(new GridLayout(3, 2));
    c.add(labelOne);
    c.add(labelTwo);
    c.add(labelThree);
    c.add(labelFour);
    c.add(labelFive);
    c.add(labelSix);

    f.setVisible(true);
  }
}
